	subroutine OUT(iout, idbg, ic, iq, iqc, iqd, ij, Nn, Np, Ns, NnNd, ldw, &
			n, time, Nc, C, T, w, work, In, Ao, &
			lastQc1, lastQd1, lastF1, &
			vQc1, vQd1, vF1, rQc1, rQd1, rF1, cQc1, cQd1, cF1)	
! write solver output, C, T and nodal fluxes

	implicit none
	integer iout, idbg, ic, iq, iqc, iqd, ij
	integer Nn, Np, Ns, ldw, NnNd	! array parameters
	integer lastQc1, lastQd1, lastF1
	integer rQc1(Nn+1), rQd1(Nn+1), rF1(Nn+1)	! global  arrays (compact rows)
	integer cQc1(NnNd), cQd1(NnNd), cF1(NnNd)	! global  arrays (compact columns)
	real*8 time
	real*8 C   (Nn,Ns), T   (Nn,Ns)		! global  arrays
	real*8 vQc1(NnNd), vQd1(NnNd), vF1(NnNd)! global  arrays (compact values)
	real*8 w(Nn,Ns), work(ldw)		! work arrays
	real*8 In(Nn,Ns,0:Np)			! convolution array M*C
	real*8 Ao(Nn)				! nodal averaged array
	integer n, Nc

	integer i, p, ii, jj, s

	write(idbg,'(a)') ' --- OUT ---'	! ### TEMPORARY ###

	Nc = Nc + 1		! counter for POST_*

! output C
	write(ic,*) 'n    = ', n
	write(ic,*) 'time = ', time
	write(ic,*) 'C(i,s)'
	do i = 1, Nn
	  write(ic,*)  (C(i,s), s = 1, Ns)				! output C
	enddo	!i
! output T
	write(iq,*) 'n    = ', n
	write(iq,*) 'time = ', time
	write(iq,*) 'T(i,s)'
	do i = 1, Nn
	  write(iq,*)  (T(i,s), s = 1, Ns)				! output T
	enddo	!i
! nodal advection flux, qc
! compute {work(Nn*(s-1)+1:Nn*(s-1)+Nn)} = [Qc1]{C} using AMUX from SPARSKIT2
	do s = 1, Ns
	  call AMUX(Nn, C(1,s), work(Nn*(s-1)+1), vQc1, cQc1, rQc1)
	enddo	! s
	write(iqc,*) 'n    = ', n
	write(iqc,*) 'time = ', time
	write(iqc,*) 'qc(i,s)'
	do ii = 1, Nn
	  write(iqc,*)  (work(Nn*(s-1)+ii), s = 1, Ns)			! output qc
	enddo	! ii
! nodal dispersion flux, qd
! compute {work(Nn*(s-1)+1:Nn*(s-1)+Nn)} = [Qd1]{C} using AMUX from SPARSKIT2
	do s = 1, Ns
	  call AMUX(Nn, C(1,s), work(Nn*(s-1)+1), vQd1, cQd1, rQd1)
	enddo	! s
	write(iqd,*) 'n    = ', n
	write(iqd,*) 'time = ', time
	write(iqd,*) 'qd(i,s)'
	do ii = 1, Nn
	  write(iqd,*)  (work(Nn*(s-1)+ii), s = 1, Ns)			! output qd
	enddo	! ii
! nodal flux, j
! calculate w = C for ADE or w = I for EXP
	if(Np .eq. 0)	then
	  w = C					! use matrix form
	else
	  do ii = 1, Nn
	    do s = 1, Ns
	      w(ii,s) = Ao(ii)*C(ii,s)		! Ao*C(ii,s)
	        do p = 1, Np
	          w(ii,s) = w(ii,s) + In(ii,s,p)	! sum In(ii,s,p) for node ii
	        enddo	! p
	    enddo	! s
	  enddo		! ii
	endif
! compute {work(Nn*(s-1)+1:Nn*(s-1)+Nn)} = [F1]{w} using AMUX from SPARSKIT2
	do s = 1, Ns
	  call AMUX(Nn, w(1,s), work(Nn*(s-1)+1), vF1, cF1, rF1)
	enddo	! s
	write(ij,*) 'n    = ', n
	write(ij,*) 'time = ', time
	write(ij,*) 'j(i,s)'
	do ii = 1, Nn
	  write(ij,*)  (work(Nn*(s-1)+ii), s = 1, Ns)			! output j
	enddo	! ii
	return
	end

